/*
 *  Config.cpp
 *
 *  Entry function WhatConfig() - this uses
 *
 *  GetVersionEx() - Windows function for OS details
 *  GetSystemInfo() - Windows function for old CPU types
 *  GlobalMemoryStatus() - Windows function for memory statistics
 *  getCPUstring() - assembly code executing the CPUID instruction
 *     to obtain CPU manufacturer ID
 *  getCPUDetails() -assembly code executing the CPUID instruction
 *     to obtain Features Code and Model Code. Features Code bits
 *     identify whether MMX, SSE and SSE2 instructions are available
 *     with a special one for AMD and 3DNow. Model Code was previously
 *     interpreted as family/model/stepping.
 *     Note: further CPU model specific features can be obtained
 *     via the CPUID instruction.     
 *  calculateMHz() - uses getStartTime() and getRunSecs() with assembly
 *     code using the RDTSC instruction that obtains instruction cycle
 *     count. This is run for at least 0.01 seconds and 10 times to
 *     obtain the maximum CPU MHz.
 *  getStartTime() - start time from high resolution timer
 *  getRunSecs() - running time from high resolution timer
 *
 *  Returns OS/CPU details in configData strings and CPU extensions
 *  via words hasMMX, hasSSE, hasSSE2, hasSSEOS, hasSSE2OS, has3DNow
 *
*/
#include "CPUID.h"
#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>

void getCPUstring(void);
void getCPUDetails(void);
void calculateMHz(void); 
double getRunSecs(void);
void   getStartTime(void);

char    configData1[200];
char    configData2[200];
char    configData3[200];
char    configData4[200];
char    configData5[200];
int     hasMMX;
int     hasSSE;
int     hasSSE2;
int     hasSSEOS;
int     hasSSE2OS;
int     has3DNow;
DWORD   ramsize;
DWORD   freesize;

char idString[20];
unsigned int megaHz;
unsigned int eaxCode;
unsigned int eaxCode1;
unsigned int edxCode;
unsigned int amdCode = 0;
LARGE_INTEGER astarttime;
double        runSecs;

#define MM_EXTENSION   0x00800000
#define SSE_EXTENSION  0x02000000
#define SSE2_EXTENSION 0x04000000
#define _3DNOW_FEATURE 0x80000000

void WhatConfig()
{
    OSVERSIONINFO vers;
    char szosBuild[20] = "";
    char os[100];
    SYSTEM_INFO info;
    BOOL  OldSys;    
    MEMORYSTATUS lpBuffer;

    hasMMX = 0;
    hasSSE = 0;
    hasSSE2 = 0;
    hasSSEOS = 0;
    hasSSE2OS = 0;
    has3DNow = 0;

    // **************** OS *********************

    vers.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

    GetVersionEx(&vers);
    
    if (vers.dwPlatformId == VER_PLATFORM_WIN32s)
    {
        strcpy(os, " Windows 3.1");
    }
    else if (vers.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
    {
        strcpy(os, " Windows 95");
        if (vers.dwMinorVersion > 0) strcpy(os, " Windows 98");
        sprintf(szosBuild, "build %d,", (DWORD)(LOWORD(vers.dwBuildNumber)));
    }
    else if (vers.dwPlatformId == VER_PLATFORM_WIN32_NT)
    {
        strcpy(os, " Windows NT");
        sprintf(szosBuild, "build %d,", vers.dwBuildNumber);

    }
    else
    {
        strcpy(os, "OS?");
    }
    sprintf (configData1, "%s Version %d.%d, %s %s",
                        os, vers.dwMajorVersion,
                        vers.dwMinorVersion, szosBuild, vers.szCSDVersion);

    sprintf (configData4, " "); 
    sprintf (configData5, " ");

                // **************** CPU *********************

    lpBuffer.dwLength = sizeof(MEMORYSTATUS);

    GetSystemInfo(&info);
        
    OldSys = FALSE;
    if (info.dwProcessorType == PROCESSOR_INTEL_386)
    {
        strcpy(configData2, " CPU Type 80386");
        OldSys = TRUE;
    }
    if (info.dwProcessorType == PROCESSOR_INTEL_486)
    {
        strcpy(configData2, " CPU Type 80486");
        OldSys = TRUE;
    }

    if (!OldSys)
    {
       getCPUstring();
       getCPUDetails();
       calculateMHz();
       if (edxCode & MM_EXTENSION)
       {
               hasMMX = 1;
               strcat(configData4, "Has MMX, ");
       }
       else
       {
               strcat(configData4, "No MMX, ");
       }
       if (edxCode & SSE_EXTENSION)
           {
                   hasSSE = 1;
                   strcat(configData4, "Has SSE, ");
           hasSSEOS = 1;
           _try
                   {
                __asm xorps xmm0, xmm0 ;Streaming SIMD Extension
                   }
           _except(EXCEPTION_EXECUTE_HANDLER)
                   {
               if (_exception_code()==STATUS_ILLEGAL_INSTRUCTION)
               /* SSE not supported */
               hasSSEOS = 0;
                   }
                   if (hasSSEOS)
                   {
               strcat(configData5, "Has SSE OS Support, ");
                   }
                   else
                   {
               strcat(configData5, "No SSE OS Support, ");
                   }

           }
           else
           {
                   strcat(configData4, "No SSE, ");
           }
       if (edxCode & SSE2_EXTENSION)
       {
           hasSSE2 = 1;
           strcat(configData4, "Has SSE2, ");
           hasSSE2OS = 1;
           _try
           {
                __asm xorpd xmm0, xmm0 ; SSE2
           }
           _except(EXCEPTION_EXECUTE_HANDLER)
           {
               if (_exception_code()==STATUS_ILLEGAL_INSTRUCTION)
               /* SSE2 not supported */
               hasSSE2OS = 0;
           }
           if (hasSSEOS)
           {
               strcat(configData5, "Has SSE2 OS Support, ");
           }
           else
           {
               strcat(configData5, "No SSE2 OS Support, ");
           }
       }
       else
       {
            strcat(configData4, "No SSE2, ");
       }
       if (amdCode & _3DNOW_FEATURE)
       {
           has3DNow = 1;
           strcat(configData4, "Has 3DNow, ");
       }
       else
       {
           strcat(configData4, "No 3DNow,");
       }
       sprintf(configData2, " CPU %s, Features Code %8.8X, Model Code %8.8X, %d MHz",
                           idString, edxCode, eaxCode, megaHz);    
    } 
    GlobalMemoryStatus(&lpBuffer);
    ramsize = lpBuffer.dwTotalPhys;
    freesize = lpBuffer.dwAvailPhys;
    sprintf(configData3, " From GlobalMemoryStatus: Size %d KB, Free %d KB", ramsize / 1024, freesize / 1024);
}

void getCPUstring(void)
{
    __asm
    {
        lea  edi, idString
        mov  eax, 0
        CPUID
        mov[edi],   ebx
        mov[edi+4], edx
        mov[edi+8], ecx
        mov[edi+12], 0
        mov eaxCode1, eax
    }
}

void getCPUDetails(void)
{
    __asm
    {
        mov  eax, 1
        CPUID
        mov eaxCode, eax  ; Features Code
        mov edxCode, edx  ; family/model/stepping

        // get AMD-specials
        mov eax,80000000h
        CPUID
        cmp eax,80000000h
        jc notamd
        mov eax,80000001h
        CPUID
        mov amdCode,edx
     notamd:
    }
}

void calculateMHz(void)
{
    unsigned int i, max;
    unsigned int startCount = 0;
    unsigned int endCount = 0;
    unsigned int cycleCount = 0;

    max = 0;
    for (i=0; i<10; i++)
    {
        getStartTime();
        __asm
        {
            RDTSC                 // Pentium op code to obtain instruction cycle count
            mov startCount, eax   
        }
    
        while (getRunSecs() < 0.01)
        {
            __asm
            {
                mov edx, 1000
              lp:
                dec edx            // misc instructions
                jnz lp
                RDTSC              // end instruction cycle count
                mov endCount, eax  
            }
        }
        cycleCount = endCount - startCount;
        megaHz = (unsigned int)((double)cycleCount / 1000000.0 / runSecs + 0.5);
        if (megaHz > max) max = megaHz;
    }
    megaHz = max;
}

void getStartTime(void)
{
    QueryPerformanceCounter(&astarttime);
}
 
double getRunSecs(void)
{
    LARGE_INTEGER liDiff;
    LARGE_INTEGER liFreq;

    QueryPerformanceCounter(&liDiff);

    liDiff.QuadPart -= astarttime.QuadPart;

    (void)QueryPerformanceFrequency(&liFreq);
    
    runSecs = (double)liDiff.QuadPart / (double) liFreq.QuadPart;
    return runSecs;
}



