import time
import utime

PicoPin20 = machine.Pin(15, machine.Pin.OUT)
loops = 100
microsecs = 100000

print(' Pico Python one output + sleep')
print('     Loops  microsecs   runsecs  cycles/sec')
for j in range (6):
    startTime = utime.ticks_ms()
    for i in range(loops):
        PicoPin20.value(1)
        utime.sleep_us(int(microsecs))
        PicoPin20.value(0)
        utime.sleep_us(int(microsecs))
    endTime = utime.ticks_ms()
    runTime = utime.ticks_diff(endTime,startTime)/1000     
    cps = loops/runTime
    print('{:10d} {:9.0f} {:9.2f} {:11.1f}' .format(loops, microsecs, runTime, cps))
    loops = loops * 10
    microsecs = microsecs / 10
print ("End")



