import time
import utime

PicoPin20 = machine.Pin(15, machine.Pin.OUT)
PicoPin19 = machine.Pin(14, machine.Pin.OUT)

PicoPin17 = machine.Pin(13, machine.Pin.OUT)
PicoPin16 = machine.Pin(12, machine.Pin.OUT)
PicoPin15 = machine.Pin(11, machine.Pin.OUT)
PicoPin14 = machine.Pin(10, machine.Pin.OUT)

PicoPin12 = machine.Pin(9, machine.Pin.OUT)
PicoPin11 = machine.Pin(8, machine.Pin.OUT)
PicoPin10 = machine.Pin(7, machine.Pin.OUT)
PicoPin9  = machine.Pin(6, machine.Pin.OUT)

PicoPin7  = machine.Pin(5, machine.Pin.OUT)
PicoPin6  = machine.Pin(4, machine.Pin.OUT)

PicoPin21 = machine.Pin(16, machine.Pin.OUT)
loops = 100

print(' Pico Python 13 outputs no sleep')
print('     Loops   runsecs  cycles/sec')
for j in range (6):
    startTime = utime.ticks_ms()
    for i in range(loops):
        PicoPin20.value(1)
        PicoPin19.value(1)

        PicoPin17.value(1)
        PicoPin16.value(1)
        PicoPin15.value(1)
        PicoPin14.value(1)

        PicoPin12.value(1)
        PicoPin11.value(1)
        PicoPin10.value(1)
        PicoPin9.value(1)

        PicoPin7.value(1)
        PicoPin6.value(1)

        PicoPin21.value(1)

        PicoPin20.value(0)
        PicoPin19.value(0)

        PicoPin17.value(0)
        PicoPin16.value(0)
        PicoPin15.value(0)
        PicoPin14.value(0)

        PicoPin12.value(0)
        PicoPin11.value(0)

        PicoPin10.value(0)
        PicoPin9.value(0)

        PicoPin7.value(0)
        PicoPin6.value(0)

        PicoPin21.value(0)
    endTime = utime.ticks_ms()
    runTime = utime.ticks_diff(endTime,startTime)/1000     
    cps = loops/runTime
    print('{:10d} {:9.2f} {:11.1f}' .format(loops, runTime, cps))
    loops = loops * 10
print ("End")

