/*
$ mkdir build
$ cd build
$ export PICO_SDK_PATH=../../pico-sdk
$ cmake ..
$ make


*/

#include <stdio.h>
#include "pico/stdlib.h"
#include "hardware/gpio.h"

const uint PicoPin15 = 15;

uint loops = 100;
uint64_t microsecs = 100000;

uint64_t startTime;
uint64_t endTime;

float runSecs;
float cps;
    
int main() 
{
   setup_default_uart();
   gpio_init(PicoPin15);

   gpio_set_dir(PicoPin15, GPIO_OUT);
   printf("\nJust sleep\n     Loops microsecs   runsecs  cycles/sec\n\n");
   for (int r = 0; r < 6; r++)
   {
      gpio_put(PicoPin15, 1);
      startTime =  time_us_64 ();
      for (int i = 0; i < loops; i++)
      { 
         busy_wait_us(microsecs);
         busy_wait_us(microsecs); 
      }
      endTime =  time_us_64 ();
      runSecs = (float)(endTime - startTime) / 1000000.0;
      cps = (float)loops / runSecs;
      printf("%10d %9ld %9.3f %10.1f \n", loops, microsecs, runSecs, cps); 
      loops = loops * 10;
      microsecs = microsecs / 10;
      gpio_put(PicoPin15, 0);
   }
   printf(" End\n\n");
   gpio_put(PicoPin15, 0);  
}

