/*
mkdir build
cd build
export PICO_SDK_PATH=../../pico-sdk
cmake ..
make
minicom -b 115200 -o -D /dev/serial0
minicom -b 115200 -o -D /dev/ttyACM0


*/

 #include <math.h>       /* for sin, exp etc.           */
 #include <stdio.h>      /* standard I/O                */ 
 #include <string.h>     /* for strcpy - 3 occurrences  */
 #include <stdlib.h>     /* for exit   - 1 occurrence   */
 #include "pico/stdlib.h"
 #include "hardware/gpio.h"



 void whetstones(long xtra, long x100, int calibrate);  
 void pa(double e[4], double t, double t2);
 void po(double e1[4], long j, long k, long l);
 void p3(double *x, double *y, double *z, double t, double t1, double t2);
 void pout(char title[22], double ops, int type, double checknum,
                  double time, int calibrate, int section);

double secs;
double startTime;


 static double loop_time[9];
 static double loop_mops[9];
 static double loop_mflops[9];
 static double TimeUsed;
 static double mwips;
 static char headings[9][18];
 static double Check;
 static double results[9];
 

int main()
{
    setup_default_uart();

    int count = 10, calibrate = 1;
    long xtra = 1;
    int section;
    long x100 = 100;
    int duration = 10;
    char compiler[80], options[256], general[10][80] = {" "};
    char endit[80];
    int i;
    int nopause = 1;

    printf("\n");
    printf("##########################################\n"); 
    printf("Double Precision C Whetstone Benchmark\n");
            
  printf("Calibrate\n");
  do
   {
    TimeUsed=0;
            
    whetstones(xtra,x100,calibrate);
            
    printf("%11.2f Seconds %10.0lf   Passes (x 100)\n",
                                     TimeUsed,(double)(xtra));
    calibrate++;
    count--;

    if (TimeUsed > 2.0)
      {
       count = 0;
      }
       else
      {
       xtra = xtra * 5;
      }
   }
   
   while (count > 0);
       
   if (TimeUsed > 0) xtra = (long)((double)(duration * xtra) / TimeUsed);
   if (xtra < 1) xtra = 1;
       
   calibrate = 0;
  
   printf("\nUse %d  passes (x 100)\n", (int)xtra);

   printf("\n          Double Precision C/C++ Whetstone Benchmark\n");

   fflush(stdout);
   printf("\nLoop content                  Result              MFLOPS "
                                "     MOPS   Seconds\n\n");
  
   TimeUsed=0;
   whetstones(xtra,x100,calibrate);

   printf("\nMWIPS            ");
   if (TimeUsed>0)
     {
      mwips=(double)(xtra) * (double)(x100) / (10 * TimeUsed);
     }
      else
     {
      mwips = 0;
     }  
   
   printf("%39.3f%19.3f\n\n",mwips,TimeUsed);
     
   if (Check == 0) printf("Wrong answer  ");

  printf ("\n");
 
 return 0;             
}

    void whetstones(long xtra, long x100, int calibrate)
      {

        long n1,n2,n3,n4,n5,n6,n7,n8,i,ix,n1mult;
        double x,y,z;              
        long j,k,l;
        double e1[4];
                        
        double t =  0.49999975;
        double t0 = t;        
        double t1 = 0.50000025;
        double t2 = 2.0;
                
        Check=0.0;
       
        n1 = 12*x100;
        n2 = 14*x100;
        n3 = 345*x100;
        n4 = 210*x100;
        n5 = 32*x100;
        n6 = 899*x100;
        n7 = 616*x100;
        n8 = 93*x100;
        n1mult = 10;

        /* Section 1, Array elements */

        e1[0] = 1.0;
        e1[1] = -1.0;
        e1[2] = -1.0;
        e1[3] = -1.0;
       startTime =  time_us_64 ();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n1*n1mult; i++)
                  {
                      e1[0] = (e1[0] + e1[1] + e1[2] - e1[3]) * t;
                      e1[1] = (e1[0] + e1[1] - e1[2] + e1[3]) * t;
                      e1[2] = (e1[0] - e1[1] + e1[2] + e1[3]) * t;
                      e1[3] = (-e1[0] + e1[1] + e1[2] + e1[3]) * t;
                  }
                t = 1.0 - t;
              }
            t =  t0;                    
         }
        secs = (time_us_64 () - startTime) / 1000000.0;
        secs = secs/(double)(n1mult);
        pout("N1 floating point\0",(double)(n1*16)*(double)(xtra),
                             1,e1[3],secs,calibrate,1);

        /* Section 2, Array as parameter */

       startTime =  time_us_64 ();
         {
            for (ix=0; ix<xtra; ix++)
              { 
                for(i=0; i<n2; i++)
                  {
                     pa(e1,t,t2);
                  }
                t = 1.0 - t;
              }
            t =  t0;
         }
        secs = (time_us_64 () - startTime) / 1000000.0;
        pout("N2 floating point\0",(double)(n2*96)*(double)(xtra),
                             1,e1[3],secs,calibrate,2);

        /* Section 3, Conditional jumps */
        j = 1;
       startTime =  time_us_64 ();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n3; i++)
                  {
                     if(j==1)       j = 2;
                     else           j = 3;
                     if(j>2)        j = 0;
                     else           j = 1;
                     if(j<1)        j = 1;
                     else           j = 0;
                  }
              }
         }
        secs = (time_us_64 () - startTime) / 1000000.0;
        pout("N3 if then else  \0",(double)(n3*3)*(double)(xtra),
                        2,(double)(j),secs,calibrate,3);

        /* Section 4, Integer arithmetic */
        j = 1;
        k = 2;
        l = 3;
        e1[0] = 0.0;
        e1[1] = 0.0;
       startTime =  time_us_64 ();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n4; i++)
                  {
                     j = j *(k-j)*(l-k);
                     k = l * k - (l-j) * k;
                     l = (l-k) * (k+j);
                     e1[l-2] = e1[l-2] + j + k + l;
                     e1[k-2] = e1[k-2] + j * k * l;
    //  was          e1[l-2] = j + k + l; and  e1[k-2] = j * k * l;
                  }
              }
         }
        secs = (time_us_64 () - startTime) / 1000000.0;
        x = (e1[0]+e1[1])/(double)n4/(double)xtra;   // was x = e1[0]+e1[1];
        pout("N4 fixed point   \0",(double)(n4*15)*(double)(xtra),
                                 2,x,secs,calibrate,4);
     
        /* Section 5, Trig functions */
        x = 0.5;
        y = 0.5;
       startTime =  time_us_64 ();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=1; i<n5; i++)
                  {
                     x = t*atan(t2*sin(x)*cos(x)/(cos(x+y)+cos(x-y)-1.0));
                     y = t*atan(t2*sin(y)*cos(y)/(cos(x+y)+cos(x-y)-1.0));
                  }
                t = 1.0 - t;
              }
            t = t0;
         }
        secs = (time_us_64 () - startTime) / 1000000.0;
        pout("N5 sin,cos etc.  \0",(double)(n5*26)*(double)(xtra),
                                 2,y,secs,calibrate,5);
  

        /* Section 6, Procedure calls */
        x = 1.0;

        y = 1.0;
        z = 1.0;
       startTime =  time_us_64 ();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n6; i++)
                  {
                     p3(&x,&y,&z,t,t1,t2);
                  }
              }
         }
        secs = (time_us_64 () - startTime) / 1000000.0;
        pout("N6 floating point\0",(double)(n6*6)*(double)(xtra),
                                1,z,secs,calibrate,6);
  
        /* Section 7, Array refrences */
        j = 0;
        k = 1;
        l = 2;
        e1[0] = 1.0;
        e1[1] = 2.0;
        e1[2] = 3.0;
       startTime =  time_us_64 ();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0;i<n7;i++)
                  {
                     po(e1,j,k,l);
                  }
              }
         }
        secs = (time_us_64 () - startTime) / 1000000.0;
        pout("N7 assignments   \0",(double)(n7*3)*(double)(xtra),
                            2,e1[2],secs,calibrate,7);
        
        /* Section 8, Standard functions */
        x = 0.75;
       startTime =  time_us_64 ();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n8; i++)
                  {
                     x = sqrt(exp(log(x)/t1));
                  }
              }
         }
        secs = (time_us_64 () - startTime) / 1000000.0;
        pout("N8 exp,sqrt etc. \0",(double)(n8*4)*(double)(xtra),
                                2,x,secs,calibrate,8);

        return;
      }


    void pa(double e[4], double t, double t2)
      {
         long j;
         for(j=0;j<6;j++)
            {
               e[0] = (e[0]+e[1]+e[2]-e[3])*t;
               e[1] = (e[0]+e[1]-e[2]+e[3])*t;
               e[2] = (e[0]-e[1]+e[2]+e[3])*t;
               e[3] = (-e[0]+e[1]+e[2]+e[3])/t2;
            }

         return;
      }

    void po(double e1[4], long j, long k, long l)
      {
         e1[j] = e1[k];
         e1[k] = e1[l];
         e1[l] = e1[j];
         return;
      }

    void p3(double *x, double *y, double *z, double t, double t1, double t2)
      {
         *x = *y;
         *y = *z;
         *x = t * (*x + *y);
         *y = t1 * (*x + *y);
         *z = (*x + *y)/t2;
         return;
      }


    void pout(char title[18], double ops, int type, double checknum,
              double time, int calibrate, int section)
      {
        double mops,mflops;

        Check = Check + checknum;
        loop_time[section] = time;
        strcpy (headings[section],title);
        TimeUsed =  TimeUsed + time;
        if (calibrate == 1)
     
          {
              results[section] = checknum;
          }
        if (calibrate == 0)
          {              
            printf("%s %24.17f    ",headings[section],results[section]);    
       
            if (type == 1)
             {
                if (time>0)
                 {
                    mflops = ops/(1000000L*time);
                 }
                else
                 {
                   mflops = 0;
                 }
                loop_mops[section] = 99999;
                loop_mflops[section] = mflops;
                printf(" %9.3f          %9.3f\n",
                 loop_mflops[section], loop_time[section]);                
             }
            else
             {
                if (time>0)
                 {
                   mops = ops/(1000000L*time);
                 }
                else
                 {
                   mops = 0;
                 }
                loop_mops[section] = mops;
                loop_mflops[section] = 0;                 
                printf("           %9.3f%9.3f\n",
                 loop_mops[section], loop_time[section]);
             }
          }
          
        return;
      }





