/*
$ mkdir build
$ cd build
$ export PICO_SDK_PATH=../../pico-sdk
$ cmake ..
$ make
minicom -b 115200 -o -D /dev/serial0

*/

#include <stdio.h>
#include "pico/stdlib.h"
#include "hardware/gpio.h"

const uint PicoPin15 = 15;

uint loops = 100;
uint64_t microsecs = 100000;
int passes = 7;
int startpass = 1;

uint64_t startTime;
uint64_t endTime;

float runSecs;
float cps;
    
int main() 
{
   setup_default_uart();

   gpio_init(PicoPin15);

   gpio_set_dir(PicoPin15, GPIO_OUT);
   printf("One Output + Sleep\n\n");
   printf("     Loops microsecs   runsecs  cycles/sec\n");

   for (int r = startpass; r < passes; r++)
   {
      startTime =  time_us_64 ();

      for (uint i = 0; i < loops; i++) 
      {
         gpio_put(PicoPin15, 1);
         busy_wait_us(microsecs);
         gpio_put(PicoPin15, 0);  
         busy_wait_us(microsecs);
      }
      endTime =  time_us_64 ();
      runSecs = (float)(endTime - startTime) / 1000000.0;
      cps = (float)loops / runSecs;
      printf("%10d %9ld %9.3f %10.1f \n", loops, microsecs, runSecs, cps); 
      loops = loops * 10;
      microsecs = microsecs / 10;
   }
   printf(" End\n\n");
}

