/*
$ mkdir build
$ cd build
$ export PICO_SDK_PATH=../../pico-sdk
$ cmake ..
$ make
minicom -b 115200 -o -D /dev/serial0

*/

#include <stdio.h>
#include "pico/stdlib.h"
#include "hardware/gpio.h"

const uint PicoPin15 = 15;
const uint PicoPin14 = 14;
const uint PicoPin13 = 13;
const uint PicoPin12 = 12;
const uint PicoPin11 = 11;
const uint PicoPin10 = 10;
const uint PicoPin9 = 9;
const uint PicoPin8 = 8;
const uint PicoPin7 = 7;
const uint PicoPin6 = 6;
const uint PicoPin5 = 5;
const uint PicoPin4 = 4;
const uint PicoPin16 = 16;

uint loops = 100;
uint64_t microsecs = 100000;
int passes = 7;
int startpass = 1;

uint64_t startTime;
uint64_t endTime;

float runSecs;
float cps;
    
int main() 
{
   setup_default_uart();

   gpio_init(PicoPin15);
   gpio_init(PicoPin14);
   gpio_init(PicoPin13);
   gpio_init(PicoPin12);
   gpio_init(PicoPin11);
   gpio_init(PicoPin10);
   gpio_init(PicoPin9);
   gpio_init(PicoPin8);
   gpio_init(PicoPin7);
   gpio_init(PicoPin6);
   gpio_init(PicoPin5);
   gpio_init(PicoPin4);
   gpio_init(PicoPin16);

   gpio_set_dir(PicoPin15, GPIO_OUT);
   gpio_set_dir(PicoPin14, GPIO_OUT);
   gpio_set_dir(PicoPin13, GPIO_OUT);
   gpio_set_dir(PicoPin12, GPIO_OUT);
   gpio_set_dir(PicoPin11, GPIO_OUT);
   gpio_set_dir(PicoPin10, GPIO_OUT);
   gpio_set_dir(PicoPin9, GPIO_OUT);
   gpio_set_dir(PicoPin8, GPIO_OUT);
   gpio_set_dir(PicoPin7, GPIO_OUT);
   gpio_set_dir(PicoPin6, GPIO_OUT);
   gpio_set_dir(PicoPin5, GPIO_OUT);
   gpio_set_dir(PicoPin4, GPIO_OUT);
   gpio_set_dir(PicoPin16, GPIO_OUT);

   printf("13 Outputs + Sleep using busy_wait_us(microsecs)\n\n");
   printf("     Loops microsecs   runsecs  cycles/sec\n");

   for (int r = startpass; r < passes; r++)
   {
      startTime =  time_us_64 ();

      for (uint i = 0; i < loops; i++) 
      {
         gpio_put(PicoPin15, 1);
         gpio_put(PicoPin14, 1);
         gpio_put(PicoPin13, 1);
         gpio_put(PicoPin12, 1);
         gpio_put(PicoPin11, 1);
         gpio_put(PicoPin10, 1);
         gpio_put(PicoPin9, 1);
         gpio_put(PicoPin8, 1);
         gpio_put(PicoPin7, 1);
         gpio_put(PicoPin6, 1);
         gpio_put(PicoPin5, 1);
         gpio_put(PicoPin4, 1);
         gpio_put(PicoPin16, 1);
         busy_wait_us(microsecs);
         gpio_put(PicoPin15, 0);  
         gpio_put(PicoPin14, 0);  
         gpio_put(PicoPin13, 0);
         gpio_put(PicoPin12, 0);
         gpio_put(PicoPin11, 0);
         gpio_put(PicoPin10, 0);
         gpio_put(PicoPin9, 0);
         gpio_put(PicoPin8, 0);
         gpio_put(PicoPin7, 0);
         gpio_put(PicoPin6, 0);
         gpio_put(PicoPin5, 0);
         gpio_put(PicoPin4, 0);
         gpio_put(PicoPin16, 0);
         busy_wait_us(microsecs);
      }
      endTime =  time_us_64 ();
      runSecs = (float)(endTime - startTime) / 1000000.0;
      cps = (float)loops / runSecs;
      printf("%10d %9ld %9.3f %10.1f \n", loops, microsecs, runSecs, cps); 
      loops = loops * 10;
      microsecs = microsecs / 10;
   }
   printf(" End\n\n");
}

